/*
 * Decompiled with CFR 0.152.
 */
package org.sensorhub.impl.sensor.plume;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import org.sensorhub.impl.sensor.plume.Plume;
import org.sensorhub.impl.sensor.plume.PlumeStep;

public class PlumeReader {
    static final double START_TIME = 1.441918699E9;

    public static Plume read(File f) throws IOException {
        assert (f.exists() && f.isFile());
        Plume plume = new Plume();
        try (BufferedReader reader = new BufferedReader(new FileReader(f));){
            String inline = reader.readLine().trim();
            String[] vals = inline.split("\\s+");
            double lon0 = Double.parseDouble(vals[0]);
            double lat0 = Double.parseDouble(vals[1]);
            double timeMod = Double.parseDouble(vals[2]);
            double runtime = Double.parseDouble(vals[3]);
            double timeStep = Double.parseDouble(vals[4]);
            double releaseType = Double.parseDouble(vals[5]);
            double numSources = Double.parseDouble(vals[6]);
            int i = 0;
            while ((double)i < numSources) {
                inline = reader.readLine().trim();
                vals = inline.split("\\s+");
                double srcLon = Double.parseDouble(vals[0]);
                double srcLat = Double.parseDouble(vals[1]);
                double srcHeight = Double.parseDouble(vals[2]);
                double tdelay = Double.parseDouble(vals[3]);
                if (i == 0) {
                    plume.sourceLat = srcLat;
                    plume.sourceLon = srcLon;
                    plume.sourceHeight = srcHeight;
                }
                ++i;
            }
            boolean eof = false;
            block10: while (!eof) {
                int i2 = 0;
                while ((double)i2 < numSources) {
                    inline = reader.readLine();
                    if (inline == null || inline.trim().length() == 0) {
                        eof = true;
                        continue block10;
                    }
                    vals = inline.trim().split("\\s+");
                    timeMod = Double.parseDouble(vals[2]) + 1.441918699E9;
                    runtime = Double.parseDouble(vals[3]);
                    double tdelay = Double.parseDouble(vals[4]);
                    int numParticles = (int)Double.parseDouble(vals[5]);
                    double[] points1d = new double[numParticles * 3];
                    for (int j = 0; j < numParticles * 3; j += 3) {
                        inline = reader.readLine().trim();
                        vals = inline.split("\\s+");
                        double lon = Double.parseDouble(vals[0]);
                        double lat = Double.parseDouble(vals[1]);
                        double alt = Double.parseDouble(vals[2]);
                        points1d[j] = lat;
                        points1d[j + 1] = lon;
                        points1d[j + 2] = alt;
                    }
                    if (i2 == 0 && numParticles > 0) {
                        PlumeStep step = new PlumeStep(timeMod, numParticles, points1d);
                        plume.addStep(step);
                    }
                    ++i2;
                }
            }
        }
        return plume;
    }

    public static void main(String[] args) throws IOException {
        File pfile = new File("C:/Data/sensorhub/plume/ppdm_ind_ms_v2/run/PARTICLE.OUT_p0");
        Plume plume = PlumeReader.read(pfile);
        System.err.println(plume);
    }
}

