/*
 * Decompiled with CFR 0.152.
 */
package org.sensorhub.impl.sensor.plume;

import java.io.File;
import java.util.List;
import net.opengis.swe.v20.BinaryEncoding;
import net.opengis.swe.v20.Count;
import net.opengis.swe.v20.DataArray;
import net.opengis.swe.v20.DataBlock;
import net.opengis.swe.v20.DataComponent;
import net.opengis.swe.v20.DataEncoding;
import org.sensorhub.api.common.Event;
import org.sensorhub.api.data.IStreamingDataInterface;
import org.sensorhub.api.sensor.ISensorModule;
import org.sensorhub.api.sensor.SensorDataEvent;
import org.sensorhub.impl.sensor.AbstractSensorOutput;
import org.sensorhub.impl.sensor.plume.Plume;
import org.sensorhub.impl.sensor.plume.PlumeConfig;
import org.sensorhub.impl.sensor.plume.PlumeReader;
import org.sensorhub.impl.sensor.plume.PlumeSensor;
import org.sensorhub.impl.sensor.plume.PlumeStep;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.vast.data.DataBlockMixed;
import org.vast.swe.SWEHelper;

public class PlumeOutput
extends AbstractSensorOutput<PlumeSensor> {
    private static final Logger log = LoggerFactory.getLogger(PlumeOutput.class);
    DataComponent plumeStep;
    BinaryEncoding encoding;

    public PlumeOutput(PlumeSensor parentSensor) {
        super((ISensorModule)parentSensor);
    }

    public String getName() {
        return "plumeModel";
    }

    protected void init() {
        SWEHelper fac = new SWEHelper();
        this.plumeStep = fac.newDataRecord(3);
        this.plumeStep.setDescription("plumeStep represents a single timeStep with point data");
        this.plumeStep.setDefinition("http://sensorml.com/ont/swe/property/LagrangianPlumeModel");
        this.plumeStep.setName(this.getName());
        this.plumeStep.addComponent("time", (DataComponent)fac.newTimeStampIsoUTC());
        Count numPoints = fac.newCount();
        numPoints.setId("NUM_POINTS");
        this.plumeStep.addComponent("num_pos", (DataComponent)numPoints);
        DataArray ptArr = fac.newDataArray();
        ptArr.setElementType("point", (DataComponent)fac.newLocationVectorLLA(null));
        ptArr.setElementCount(numPoints);
        this.plumeStep.addComponent("points", (DataComponent)ptArr);
        this.encoding = SWEHelper.getDefaultBinaryEncoding((DataComponent)this.plumeStep);
    }

    protected void start() {
        final File pfile = new File(((PlumeConfig)((PlumeSensor)this.parentSensor).getConfiguration()).dataPath);
        Thread t = new Thread(){

            @Override
            public void run() {
                try {
                    Thread.sleep(1000L);
                    Plume plume = PlumeReader.read(pfile);
                    List<PlumeStep> steps = plume.getSteps();
                    for (PlumeStep step : steps) {
                        DataBlock dataBlock = null;
                        DataArray ptArr = (DataArray)PlumeOutput.this.plumeStep.getComponent(2);
                        ptArr.updateSize(step.getNumParticles());
                        dataBlock = PlumeOutput.this.plumeStep.createDataBlock();
                        dataBlock.setDoubleValue(0, step.getTime());
                        dataBlock.setIntValue(1, step.getNumParticles());
                        ((DataBlockMixed)dataBlock).getUnderlyingObject()[2].setUnderlyingObject((Object)step.points1d);
                        PlumeOutput.this.latestRecord = dataBlock;
                        PlumeOutput.this.latestRecordTime = (long)step.getTime() * 1000L;
                        PlumeOutput.this.eventHandler.publishEvent((Event)new SensorDataEvent(PlumeOutput.this.latestRecordTime, "urn:test:sensors:model:plume", (IStreamingDataInterface)PlumeOutput.this, new DataBlock[]{PlumeOutput.this.latestRecord}));
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        };
        t.start();
    }

    protected void stop() {
    }

    public double getAverageSamplingPeriod() {
        return 1.0;
    }

    public DataComponent getRecordDescription() {
        return this.plumeStep;
    }

    public DataEncoding getRecommendedEncoding() {
        return this.encoding;
    }
}

